 

<?php $__env->startSection('title', $post->title . ' Detayı | The Listoria'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto max-w-3xl py-8">
        
        
        <div class="bg-white p-6 rounded-lg shadow-xl mb-8">
            <h1 class="text-4xl font-extrabold text-gray-800 mb-2"><?php echo e($post->title); ?></h1>
            <p class="text-gray-600 text-lg mb-4"><?php echo e($post->description); ?></p>
            
            <div class="text-sm text-gray-500 space-x-4 border-t pt-4 mt-4">
                <?php if($post->publish_year): ?>
                    <span>Yayın Yılı: <?php echo e($post->publish_year); ?></span>
                <?php endif; ?>
                <span>Oluşturulma: <?php echo e($post->created_at->format('d M Y')); ?></span>
                
                
                <?php
                    $mainStatus = $post->lists()->first()->pivot->user_status ?? 'Durum Yok';
                ?>
                <span class="font-bold px-2 py-1 rounded 
                    <?php if($mainStatus == 'Tamamlandı'): ?> bg-green-200 text-green-800
                    <?php elseif($mainStatus == 'Devam Ediyor'): ?> bg-blue-200 text-blue-800
                    <?php else: ?> bg-yellow-200 text-yellow-800
                    <?php endif; ?>">
                    Aktif Durum: <?php echo e($mainStatus); ?>

                </span>
            </div>
            
            <div class="flex space-x-3 mt-6 border-t pt-4">
                
                <a href="<?php echo e(route('posts.edit', $post->id)); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded text-sm transition duration-150">
                    İçeriği Düzenle
                </a>
                
                
                <form action="<?php echo e(route('posts.destroy', $post->id)); ?>" method="POST" onsubmit="return confirm('UYARI: Bu içerik ve tüm liste bağlantıları kalıcı olarak silinecektir. Emin misiniz?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded text-sm transition duration-150">
                        Kalıcı Olarak Sil
                    </button>
                </form>
                
                <a href="<?php echo e(route('profile.show', ['username' => Auth::user()->username])); ?>" class="text-gray-600 hover:text-gray-800 self-center text-sm">
                    &larr; Tüm Listelerime Dön
                </a>
            </div>
        </div>

        
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Bağlı Olduğu Listeler (<?php echo e($attachedLists->count()); ?>)</h2>
        
        <div class="space-y-3">
            <?php if($attachedLists->isEmpty()): ?>
                 <p class="text-gray-500">Bu içerik şu anda hiçbir listeye bağlı değil.</p>
            <?php else: ?>
                <?php $__currentLoopData = $attachedLists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-gray-50 p-4 rounded-lg flex justify-between items-center border">
                        <div>
                            <p class="text-lg font-semibold text-indigo-700">
                                <a href="<?php echo e(route('lists.show', $list->id)); ?>" class="hover:underline"><?php echo e($list->name); ?></a>
                            </p>
                            <span class="text-xs text-gray-500">
                                Türü: <span class="font-bold text-gray-700"><?php echo e($list->type); ?></span>
                                <br/> <?php echo e($list->is_fixed ? 'Sabit Liste' : 'Manuel Liste'); ?>

                                (<?php echo e($list->is_public ? 'Herkese Açık' : 'Gizli'); ?>)
                            </span>
<!--
                            <span class="text-xs text-gray-500">
                                <?php echo e($list->is_fixed ? 'Sabit Liste' : 'Manuel Liste'); ?>

                                (<?php echo e($list->is_public ? 'Herkese Açık' : 'Gizli'); ?>)
                            </span>
-->
                        </div>
                        
                        <span class="text-sm font-medium px-3 py-1 rounded-full 
                            <?php if($list->pivot->user_status == 'Tamamlandı'): ?> bg-green-100 text-green-700
                            <?php elseif($list->pivot->user_status == 'Devam Ediyor'): ?> bg-blue-100 text-blue-700
                            <?php else: ?> bg-yellow-100 text-yellow-700
                            <?php endif; ?>">
                            Durum: <?php echo e($list->pivot->user_status); ?>

                        </span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/storia/public_html/dev.thelistoria.com/resources/views/posts/show.blade.php ENDPATH**/ ?>