<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Post;
use App\Models\Like; // Favori (Kalp)
use App\Models\Approval; // Beğeni (Parmak)
use App\Models\UserList;
use Illuminate\Support\Facades\Auth;

class InteractionController extends Controller
{
    public function toggleLike(Post $post)
    {
        $user = Auth::user();
        
        // Mevcut kaydı buluyoruz
        $likeExists = Like::where('user_id', $user->id)->where('post_id', $post->id)->exists();

        // Kullanıcının "Favorilerim" listesini buluyoruz
        $favoriteList = UserList::where('user_id', $user->id)
                            ->where('name', 'Favorilerim')
                            ->where('is_fixed', 1)
                            ->first();

        if ($likeExists) {
            // SİLME: Model nesnesi üzerinden değil, doğrudan tablo üzerinden şartla siliyoruz
            // Bu yöntem 'id' sütunu aramaz.
            Like::where('user_id', $user->id)->where('post_id', $post->id)->delete();

            if ($favoriteList) {
                $favoriteList->posts()->detach($post->id);
            }

            return response()->json([
                'success' => true,
                'status' => 'unliked',
                'likes_count' => $post->likes()->count()
            ]);
        } else {
            // EKLEME
            Like::create([
                'user_id' => $user->id,
                'post_id' => $post->id
            ]);

            if ($favoriteList) {
                $favoriteList->posts()->syncWithoutDetaching([$post->id => ['user_status' => 'Tamamlandı']]);
            }

            return response()->json([
                'success' => true,
                'status' => 'liked',
                'likes_count' => $post->likes()->count()
            ]);
        }
    }

    public function toggleApproval(Post $post)
    {
        $user = Auth::user();
        
        $approvalExists = Approval::where('user_id', $user->id)->where('post_id', $post->id)->exists();

        // Kullanıcının "Beğendiklerim" listesini buluyoruz
        $approvalList = UserList::where('user_id', $user->id)
                            ->where('name', 'Beğendiklerim')
                            ->where('is_fixed', 1)
                            ->first();

        if ($approvalExists) {
            // SİLME
            Approval::where('user_id', $user->id)->where('post_id', $post->id)->delete();

            if ($approvalList) {
                $approvalList->posts()->detach($post->id);
            }

            return response()->json([
                'success' => true,
                'status' => 'unapproved',
                'approvals_count' => $post->approvals()->count()
            ]);
        } else {
            // EKLEME
            Approval::create([
                'user_id' => $user->id,
                'post_id' => $post->id
            ]);

            if ($approvalList) {
                $approvalList->posts()->syncWithoutDetaching([$post->id => ['user_status' => 'Tamamlandı']]);
            }

            return response()->json([
                'success' => true,
                'status' => 'approved',
                'approvals_count' => $post->approvals()->count()
            ]);
        }
    }
}