 

<?php $__env->startSection('title', '@' . $user->username . ' Profili | The Listoria'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto py-8">
        
        
        <div class="bg-white p-6 rounded-lg shadow-xl mb-8">
            <h1 class="text-4xl font-bold text-gray-800 mb-2">@ <?php echo e($user->username); ?></h1>
            <p class="text-gray-600 text-lg"><?php echo e($user->name); ?></p>
            
            <?php if($is_owner): ?>
                <div class="mt-4 flex space-x-3">
                    <a href="<?php echo e(route('posts.create')); ?>" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded transition">
                        + Yeni İçerik Ekle
                    </a>
                    <a href="<?php echo e(route('lists.create')); ?>" class="bg-indigo-500 hover:bg-indigo-600 text-white font-bold py-2 px-4 rounded transition">
                        + Yeni Liste Oluştur
                    </a>
                </div>
            <?php endif; ?>
        </div>

        
        <h2 class="text-2xl font-bold text-gray-800 mb-4">
            <?php echo e($is_owner ? 'Listelerim' : 'Herkese Açık Listeleri'); ?> (<?php echo e($lists->count()); ?>)
        </h2>
        
        <?php if($lists->isEmpty()): ?>
            <p class="text-gray-500">Henüz listesi bulunmamaktadır.</p>
        <?php else: ?>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php $__currentLoopData = $lists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white p-5 rounded-lg shadow border-l-4 <?php echo e($list->is_fixed ? 'border-red-500' : 'border-indigo-500'); ?>">
                        <h3 class="text-xl font-semibold mb-2 flex justify-between items-start">
                            <span><?php echo e($list->name); ?></span>
                            <span class="text-sm font-normal bg-gray-200 text-gray-600 px-2 py-0.5 rounded-full ml-2">
                                <?php echo e($list->posts_count); ?> İçerik
                            </span>
                        </h3>
                        <p class="text-gray-600 text-sm mb-3 h-10 overflow-hidden"><?php echo e($list->description); ?></p>
                           
                        <div class="text-xs text-gray-500 mb-1 mt-2 flex justify-between">
                            <span class="font-medium text-indigo-700"><?php echo e($list->type); ?></span>
                        </div>
                        <div class="flex justify-between items-center text-sm text-gray-500">
                            <div>
                                <?php if($list->is_fixed): ?>
                                    <span class="text-red-500 font-medium">Sabit Liste</span>
                                <?php else: ?>
                                    <span class="<?php echo e($list->is_public ? 'text-green-500' : 'text-orange-500'); ?> font-medium">
                                        <?php echo e($list->is_public ? 'Herkese Açık' : 'Gizli'); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                            <a href="<?php echo e(route('lists.show', $list->id)); ?>" class="text-indigo-600 hover:text-indigo-800 font-medium">
                                Detayları Gör &rarr;
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/storia/public_html/dev.thelistoria.com/resources/views/profile/show.blade.php ENDPATH**/ ?>