@extends('layouts.app') 

@section('title', $post->title . ' Detayı | The Listoria')

@section('content')
    <div class="container mx-auto max-w-3xl py-8">
        
        {{-- Başlık ve Aksiyonlar --}}
        <div class="bg-white p-6 rounded-lg shadow-xl mb-8">
            <h1 class="text-4xl font-extrabold text-gray-800 mb-2">{{ $post->title }}</h1>
            
            {{-- Beğeni ve Favori Butonları --}}
            <div class="flex items-center space-x-6 my-6 p-4 bg-gray-50 rounded-lg">
                {{-- Favori (Like/Kalp) Butonu --}}
                <button onclick="toggleInteraction('{{ route('posts.toggleLike', $post) }}', 'like-btn')" class="flex items-center space-x-2 focus:outline-none group">
                    <svg id="like-icon" xmlns="http://www.w3.org/2000/svg" 
                         class="h-8 w-8 transition-colors duration-200 {{ $post->isLikedBy(auth()->user()) ? 'text-red-500 fill-current' : 'text-gray-400' }}" 
                         viewBox="0 0 24 24" stroke="currentColor" fill="none">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z" />
                    </svg>
                    <span id="like-count" class="font-semibold text-gray-700">{{ $post->likes()->count() }}</span>
                </button>

                {{-- Beğeni (Approval/Parmak) Butonu --}}
                <button onclick="toggleInteraction('{{ route('posts.toggleApproval', $post) }}', 'approve-btn')" class="flex items-center space-x-2 focus:outline-none group">
                    <svg id="approve-icon" xmlns="http://www.w3.org/2000/svg" 
                         class="h-8 w-8 transition-colors duration-200 {{ $post->isApprovedBy(auth()->user()) ? 'text-blue-500 fill-current' : 'text-gray-400' }}" 
                         viewBox="0 0 24 24" stroke="currentColor" fill="none">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.757c1.246 0 2.25 1.004 2.25 2.25 0 .402-.105.778-.29 1.103l-3 5.25c-.347.607-1.005.997-1.71.997H7V10l3-7 1 1.5V10h3z" />
                    </svg>
                    <span id="approve-count" class="font-semibold text-gray-700">{{ $post->approvals()->count() }}</span>
                </button>
            </div>
            {{-- Beğeni ve Favori Butonları END --}}
            
            <p class="text-gray-600 text-lg mb-4">{{ $post->description }}</p>
            
            <div class="text-sm text-gray-500 space-x-4 border-t pt-4 mt-4">
                @if($post->publish_year)
                    <span>Yayın Yılı: {{ $post->publish_year }}</span>
                @endif
                <span>Oluşturulma: {{ $post->created_at->format('d M Y') }}</span>
                
                {{-- Postun Ana Durumu (Herhangi bir liste pivotundaki durum) --}}
                @php
                    $mainStatus = $post->lists()->first()->pivot->user_status ?? 'Durum Yok';
                @endphp
                <span class="font-bold px-2 py-1 rounded 
                    @if($mainStatus == 'Tamamlandı') bg-green-200 text-green-800
                    @elseif($mainStatus == 'Devam Ediyor') bg-blue-200 text-blue-800
                    @else bg-yellow-200 text-yellow-800
                    @endif">
                    Aktif Durum: {{ $mainStatus }}
                </span>
            </div>
            
            <div class="flex space-x-3 mt-6 border-t pt-4">
                {{-- Düzenle Butonu --}}
                <a href="{{ route('posts.edit', $post->id) }}" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded text-sm transition duration-150">
                    İçeriği Düzenle
                </a>
                
                {{-- Silme Formu --}}
                <form action="{{ route('posts.destroy', $post->id) }}" method="POST" onsubmit="return confirm('UYARI: Bu içerik ve tüm liste bağlantıları kalıcı olarak silinecektir. Emin misiniz?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded text-sm transition duration-150">
                        Kalıcı Olarak Sil
                    </button>
                </form>
                
                <a href="{{ route('profile.show', ['username' => Auth::user()->username]) }}" class="text-gray-600 hover:text-gray-800 self-center text-sm">
                    &larr; Tüm Listelerime Dön
                </a>
            </div>
        </div>

        {{-- Bağlı Olduğu Listeler --}}
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Bağlı Olduğu Listeler ({{ $attachedLists->count() }})</h2>
        
        <div class="space-y-3">
            @if($attachedLists->isEmpty())
                 <p class="text-gray-500">Bu içerik şu anda hiçbir listeye bağlı değil.</p>
            @else
                @foreach ($attachedLists as $list)
                    <div class="bg-gray-50 p-4 rounded-lg flex justify-between items-center border">
                        <div>
                            <p class="text-lg font-semibold text-indigo-700">
                                <a href="{{ route('lists.show', $list->id) }}" class="hover:underline">{{ $list->name }}</a>
                            </p>
                            <span class="text-xs text-gray-500">
                                Türü: <span class="font-bold text-gray-700">{{ $list->type }}</span>
                                <br/> {{ $list->is_fixed ? 'Sabit Liste' : 'Manuel Liste' }}
                                ({{ $list->is_public ? 'Herkese Açık' : 'Gizli' }})
                            </span>
<!--
                            <span class="text-xs text-gray-500">
                                {{ $list->is_fixed ? 'Sabit Liste' : 'Manuel Liste' }}
                                ({{ $list->is_public ? 'Herkese Açık' : 'Gizli' }})
                            </span>
-->
                        </div>
                        
                        <span class="text-sm font-medium px-3 py-1 rounded-full 
                            @if($list->pivot->user_status == 'Tamamlandı') bg-green-100 text-green-700
                            @elseif($list->pivot->user_status == 'Devam Ediyor') bg-blue-100 text-blue-700
                            @else bg-yellow-100 text-yellow-700
                            @endif">
                            Durum: {{ $list->pivot->user_status }}
                        </span>
                    </div>
                @endforeach
            @endif
        </div>
        
    </div>
@endsection

@section('scripts')    
    <script>
    function toggleInteraction(url, type) {
        console.log("İstek gönderilen URL:", url); // URL'yi konsola yazdırır

        fetch(url, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            },
        })
        .then(response => {
            console.log("Sunucu yanıt kodu:", response.status); // 200, 404, 500 vb.
            return response.json();
        })
        .then(data => {
            console.log("Gelen Veri:", data); // Sunucudan gelen JSON yanıtı
            if (data.success) {
                if (type === 'like-btn') {
                    const icon = document.getElementById('like-icon');
                    const count = document.getElementById('like-count');
                    count.innerText = data.likes_count;

                    if (data.status === 'liked') {
                        icon.classList.add('text-red-500', 'fill-current');
                        icon.classList.remove('text-gray-400');
                    } else {
                        icon.classList.remove('text-red-500', 'fill-current');
                        icon.classList.add('text-gray-400');
                    }
                } else if (type === 'approve-btn') {
                    const icon = document.getElementById('approve-icon');
                    const count = document.getElementById('approve-count');
                    count.innerText = data.approvals_count;

                    if (data.status === 'approved') {
                        icon.classList.add('text-blue-500', 'fill-current');
                        icon.classList.remove('text-gray-400');
                    } else {
                        icon.classList.remove('text-blue-500', 'fill-current');
                        icon.classList.add('text-gray-400');
                    }
                }
            }
        })
        .catch(error => {
            console.error('Hata Detayı:', error);
            alert('İşlem başarısız oldu. Konsol (F12) kayıtlarına bakınız.');
        });
    }
    </script>
@endsection