@extends('layouts.app') 

@section('title', '@' . $user->username . ' Profili | The Listoria')

@section('content')
    <div class="container mx-auto py-8">
        
        {{-- Profil Başlığı --}}
        <div class="bg-white p-6 rounded-lg shadow-xl mb-8">
            <h1 class="text-4xl font-bold text-gray-800 mb-2">@ {{ $user->username }}</h1>
            <p class="text-gray-600 text-lg">{{ $user->name }}</p>
            
            @if($is_owner)
                <div class="mt-4 flex space-x-3">
                    <a href="{{ route('posts.create') }}" class="bg-green-500 hover:bg-green-600 text-white font-bold py-2 px-4 rounded transition">
                        + Yeni İçerik Ekle
                    </a>
                    <a href="{{ route('lists.create') }}" class="bg-indigo-500 hover:bg-indigo-600 text-white font-bold py-2 px-4 rounded transition">
                        + Yeni Liste Oluştur
                    </a>
                </div>
            @endif
        </div>

        {{-- Sekme Menüsü (Sadece Sahibi İçin) --}}
        <div class="flex items-center space-x-8 mb-6 border-b border-gray-200">
            <button onclick="switchTab('lists-section')" id="btn-lists" class="pb-4 px-2 text-xl font-bold border-b-2 border-indigo-600 text-indigo-600 transition-all">
                {{ $is_owner ? 'Listelerim' : 'Herkese Açık Listeleri' }} ({{ $lists->count() }})
            </button>
            
            @if($is_owner)
            <button onclick="switchTab('posts-section')" id="btn-posts" class="pb-4 px-2 text-xl font-bold border-b-2 border-transparent text-gray-500 hover:text-indigo-600 transition-all">
                Tüm Postlarım ({{ $posts->count() }})
            </button>
            @endif
        </div>
        
        {{-- LİSTELER ALANI --}}
        <div id="lists-section" class="block">
            @if($lists->isEmpty())
                <p class="text-gray-500">Henüz listesi bulunmamaktadır.</p>
            @else
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach ($lists as $list)
                        <div class="bg-white p-5 rounded-lg shadow border-l-4 {{ $list->is_fixed ? 'border-red-500' : 'border-indigo-500' }}">
                            <h3 class="text-xl font-semibold mb-2 flex justify-between items-start">
                                <span>{{ $list->name }}</span>
                                <span class="text-sm font-normal bg-gray-200 text-gray-600 px-2 py-0.5 rounded-full ml-2">
                                    {{ $list->posts_count }} İçerik
                                </span>
                            </h3>
                            <p class="text-gray-600 text-sm mb-3 h-10 overflow-hidden">{{ $list->description }}</p>
                               
                            <div class="text-xs text-gray-500 mb-1 mt-2 flex justify-between">
                                <span class="font-medium text-indigo-700">{{ $list->type }}</span>
                            </div>
                            <div class="flex justify-between items-center text-sm text-gray-500">
                                <div>
                                    @if($list->is_fixed)
                                        <span class="text-red-500 font-medium">Sabit Liste</span>
                                    @else
                                        <span class="{{ $list->is_public ? 'text-green-500' : 'text-orange-500' }} font-medium">
                                            {{ $list->is_public ? 'Herkese Açık' : 'Gizli' }}
                                        </span>
                                    @endif
                                </div>
                                <a href="{{ route('lists.show', $list->id) }}" class="text-indigo-600 hover:text-indigo-800 font-medium">
                                    Detayları Gör &rarr;
                                </a>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>

        {{-- POSTLAR ALANI (Sadece Sahibi İçin ve Başlangıçta Gizli) --}}
        @if($is_owner)
        <div id="posts-section" class="hidden">
            @if($posts->isEmpty())
                <p class="text-gray-500">Henüz bir post paylaşmadınız.</p>
            @else
                <div class="bg-white rounded-lg shadow overflow-hidden">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Başlık</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Yıl</th>
                                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">İşlem</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($posts as $post)
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ $post->title }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $post->publish_year ?? '-' }}</td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="{{ route('posts.show', $post->id) }}" class="text-indigo-600 hover:text-indigo-900">Görüntüle</a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @endif
        </div>
        @endif
        
    </div>

    {{-- Sekme Geçiş Scripti --}}
    <script>
        function switchTab(tabId) {
            const listsSection = document.getElementById('lists-section');
            const postsSection = document.getElementById(tabId === 'posts-section' ? 'posts-section' : null);
            const btnLists = document.getElementById('btn-lists');
            const btnPosts = document.getElementById('btn-posts');

            if (tabId === 'posts-section') {
                listsSection.classList.add('hidden');
                document.getElementById('posts-section').classList.remove('hidden');
                
                // Buton stilleri
                btnPosts.classList.add('border-indigo-600', 'text-indigo-600');
                btnPosts.classList.remove('border-transparent', 'text-gray-500');
                btnLists.classList.remove('border-indigo-600', 'text-indigo-600');
                btnLists.classList.add('border-transparent', 'text-gray-500');
            } else {
                listsSection.classList.remove('hidden');
                if(document.getElementById('posts-section')) {
                    document.getElementById('posts-section').classList.add('hidden');
                }
                
                // Buton stilleri
                btnLists.classList.add('border-indigo-600', 'text-indigo-600');
                btnLists.classList.remove('border-transparent', 'text-gray-500');
                if(btnPosts) {
                    btnPosts.classList.remove('border-indigo-600', 'text-indigo-600');
                    btnPosts.classList.add('border-transparent', 'text-gray-500');
                }
            }
        }
    </script>
@endsection