 

<?php $__env->startSection('title', $list->name . ' Listesi | The Listoria'); ?>

<?php $__env->startSection('content'); ?>
    <div class="container mx-auto py-8">
        
        
        <div class="bg-white p-6 rounded-lg shadow-xl mb-8">
            <div class="flex justify-between items-start">
                <div>
                    <h1 class="text-4xl font-bold text-gray-800 mb-2"><?php echo e($list->name); ?></h1>
                    <p class="text-gray-600 text-lg mb-2"><?php echo e($list->description); ?></p>
                    <div class="text-sm text-gray-500 space-x-3">
                        <span><?php echo e($posts->total()); ?> İçerik</span>
                        <?php if(!$list->is_fixed): ?>
                            <span class="<?php echo e($list->is_public ? 'text-green-500' : 'text-orange-500'); ?> font-medium">
                                <?php echo e($list->is_public ? 'Herkese Açık' : 'Gizli Liste'); ?>

                            </span>
                        <?php else: ?>
                            <span class="text-red-500 font-medium">Sabit Liste</span>
                        <?php endif; ?>
                        <span>| <?php echo e($list->type); ?></span>
                    </div>
                </div>

                <?php if($is_owner): ?>
                    <div class="flex space-x-3 mt-4">
                        
                        <?php if(!$list->is_fixed): ?>
                            <a href="<?php echo e(route('lists.edit', $list->id)); ?>" class="bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded text-sm transition">
                                Listeyi Düzenle
                            </a>
                        <?php endif; ?>

                        
                        <form action="<?php echo e(route('lists.destroy', $list->id)); ?>" method="POST" onsubmit="return confirm('Bu listeyi ve tüm içerik ilişkilerini silmek istediğinizden emin misiniz?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-bold py-2 px-4 rounded text-sm transition">
                                Listeyi Sil
                            </button>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
            
            <!-- <a href="<?php echo e(route('profile.show', ['username' => $list->user->username])); ?>" class="mt-4 inline-block text-indigo-600 hover:underline text-sm">
                &larr; Tüm Listelerime Dön
            </a> -->
            <!-- <a href="<?php echo e(route('profile.show', $list->user->username)); ?>" class="mt-4 inline-block text-indigo-600 hover:underline text-sm">
                ← <?php echo e($is_owner ? 'Tüm Listelerime Dön' : '@' . $list->user->username . ' Listelere Dön'); ?>

            </a> -->
            <a href="<?php echo e(route('profile.show', $list->user->username)); ?>" class="mt-4 inline-block text-indigo-600 hover:underline text-sm">
                ← <?php echo e($is_owner ? 'Tüm Listelerime Dön' : 'Tüm Listelere Dön'); ?>

            </a>
        </div>

        
        <h2 class="text-2xl font-bold text-gray-800 mb-4">Listedeki İçerikler</h2>
        
        <?php if($posts->isEmpty()): ?>
            <p class="text-gray-500">Bu listede henüz içerik bulunmamaktadır.</p>
            <?php if($is_owner): ?>
                <a href="<?php echo e(route('posts.create')); ?>" class="text-indigo-600 hover:underline">Şimdi bir içerik ekle!</a>
            <?php endif; ?>
        <?php else: ?>
            <div class="space-y-4">
                <?php $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white p-5 rounded-lg shadow flex justify-between items-center">
                        <div>
                            <h3 class="text-xl font-semibold text-gray-800"><?php echo e($post->title); ?></h3>
                            <p class="text-gray-600 text-sm mt-1">
                                <?php echo e($post->description ? Str::limit($post->description, 100) : 'Açıklama yok.'); ?>

                            </p>
                            <span class="text-xs text-gray-500 mt-2 block">
                                Yıl: <?php echo e($post->publish_year ?? 'Bilinmiyor'); ?>

                            </span>
                        </div>
                        
                        <div class="text-right flex items-center space-x-4">
                            
                            <span class="text-sm font-medium px-3 py-1 rounded-full 
                                <?php if($post->pivot->user_status == 'Tamamlandı'): ?> bg-green-100 text-green-700
                                <?php elseif($post->pivot->user_status == 'Devam Ediyor'): ?> bg-blue-100 text-blue-700
                                <?php else: ?> bg-yellow-100 text-yellow-700
                                <?php endif; ?>">
                                Durum: <?php echo e($post->pivot->user_status); ?>

                            </span>
                            
                            
                            <?php if($is_owner): ?>
                                <?php if(!$list->is_fixed): ?>
                                    <form action="<?php echo e(route('lists.removePost', ['list' => $list->id, 'postId' => $post->id])); ?>" method="POST" onsubmit="return confirm('Bu içeriği listeden çıkarmak istediğinizden emin misiniz?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="bg-red-500 hover:bg-red-600 text-white font-bold py-2 px-4 rounded text-sm transition">
                                            Listeden Çıkar
                                        </button>
                                    </form>
                                <?php endif; ?>
                            
                            
                            <?php if($is_owner): ?>
                                <a href="<?php echo e(route('posts.show', $post->id)); ?>" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded text-sm transition">
                                        Detaylar
                                </a>
                                <?php else: ?> 
                            
                                <a href="<?php echo e(route('posts.show', $post->id)); ?>" class="bg-gray-200 hover:bg-gray-300 text-gray-700 font-bold py-2 px-4 rounded text-sm transition">
                                    Detaylar
                                </a>
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="mt-6">
                <?php echo e($posts->links()); ?> 
            </div>
        <?php endif; ?>
        
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/storia/public_html/dev.thelistoria.com/resources/views/lists/show.blade.php ENDPATH**/ ?>